package chatclient;

import java.io.*;
import java.net.*;
import java.util.*;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
This program implements a multithreaded server that listens to port 8189 and echoes back 
all client input.
Copied code from Cay Horstmann
@version 1.20 2004-08-03
 */
public class Client implements Runnable {

    private static String serverIP;
    private PrintWriter out;
    private Scanner in;
    private Socket connection;
    
    private ArrayList<String> peers; // an array of the name of peers the client knows of
    
    /**
     * Builds a client
     * @param ip The IP that the client should connect to
     * @throws java.io.IOException
     */
    public Client(String ip) throws IOException {
        serverIP = ip;
        connection = new Socket(serverIP, 8189);
        ChatGui.MessageOut("Connection to server complete.");
        OutputStream output = connection.getOutputStream();
        out = new PrintWriter(output, true);
        in = new Scanner(connection.getInputStream());
        peers = new ArrayList<String>();
    }

    public void run() {
        while (connection.isConnected() && in.hasNextLine()) {
                String line = in.nextLine();
                String[] items = line.split(" ");
                if (items[1].equals("joined")) {
                    peers.add(items[0]); // parses out the name and adds it to the list
                }
                if (items[1].equals("quit")) {
                    peers.remove(items[0]); // removes from the list
                }
                if (items[1].equals("became")) {
                    peers.remove(items[0]);
                    peers.add(items[2]);
                }
                ChatGui.updateList();
                ChatGui.MessageOut(line);
        }
        ChatGui.MessageOut("Connection closed...");  // if the user uses "/quit" then the button doesn't switch
                                                          // this is another way of showing the client is disconnected
        try {    connection.close();
        } catch (IOException ex) {
            Logger.getLogger(Client.class.getName()).log(Level.SEVERE, null, ex);
        }
        peers = new ArrayList<String>(); // clears the list of peers
        ChatGui.updateList();
        ChatGui.updateBut();
    }
    
    /**
     * Checks if the socket is open
     * @return if the socket has a connection
     */
    public boolean connected() {
        return (!connection.isClosed());
    }
    
    /**
     * Returns an array of the names of peers
     * @return an array of peer names
     */
    public Object[] getClients() {
        return peers.toArray();
    }

    /**
     * Sends the server a line
     * @param s the string to "chat" to the server
     */
    public void chat(String s) {
        out.println(s);
    }
}