/*
 * ChatGui.java
 *
 * Created on March 10, 2009, 12:56 PM
 */
package chatclient;

import java.io.IOException;
import java.util.*;
import java.sql.*;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * A Chat Client that connects to the IP
 * @author  isaaclw
 */
public class ChatGui extends javax.swing.JFrame {

    private static Client aClient;
    private static Thread clientThread;

    private static final String SERVER_IP = "127.0.0.1";
    
    
    /** Creates new form ChatGui */
    public ChatGui() {
        initComponents();
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {

            public void run() {
                new ChatGui().setVisible(true);
                txtChat.setText("Gui Created, ready to start");
            }
        });
    }

    /** This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        dialogPane = new javax.swing.JScrollPane();
        txtChat = new javax.swing.JTextArea();
        txtCommand = new javax.swing.JTextField();
        butSend = new javax.swing.JButton();
        listPane = new javax.swing.JScrollPane();
        clientList = new javax.swing.JList();
        butConnect = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);

        txtChat.setColumns(20);
        txtChat.setEditable(false);
        txtChat.setLineWrap(true);
        txtChat.setRows(5);
        txtChat.setCaretPosition(txtChat.getCaretPosition());
        txtChat.setRequestFocusEnabled(false);
        dialogPane.setViewportView(txtChat);

        txtCommand.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                txtCommandActionPerformed(evt);
            }
        });

        butSend.setText("Send");
        butSend.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                butSendActionPerformed(evt);
            }
        });

        clientList.setRequestFocusEnabled(false);
        listPane.setViewportView(clientList);

        butConnect.setText("Connect");
        butConnect.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                butConnectActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(butConnect, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(listPane, javax.swing.GroupLayout.DEFAULT_SIZE, 111, Short.MAX_VALUE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(txtCommand, javax.swing.GroupLayout.DEFAULT_SIZE, 410, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(butSend))
                    .addComponent(dialogPane, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 461, Short.MAX_VALUE)))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(listPane, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 288, Short.MAX_VALUE)
                    .addComponent(dialogPane, javax.swing.GroupLayout.DEFAULT_SIZE, 288, Short.MAX_VALUE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(butSend)
                    .addComponent(txtCommand, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(butConnect)))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

private void butSendActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_butSendActionPerformed
    send();
}//GEN-LAST:event_butSendActionPerformed

private void txtCommandActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_txtCommandActionPerformed
    send();
}//GEN-LAST:event_txtCommandActionPerformed

private void butConnectActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_butConnectActionPerformed
    if ((aClient == null)||(!aClient.connected())) {
        connect();
        
    } else {
        disconnect();
    }
}//GEN-LAST:event_butConnectActionPerformed

   /**
    * Disconects the client
    */
    private void disconnect() {
            aClient.chat("/quit I'm done here");
            updateBut();
    }

    /**
     * connects the client
     */
    private void connect() {
        try {
                aClient = new Client(SERVER_IP); // have to wait to start the server till we're accepting incoming.
            } catch (IOException ex) {
                Logger.getLogger(ChatGui.class.getName()).log(Level.SEVERE, null, ex);
            }
            clientThread = new Thread(aClient);
            clientThread.start();
            updateBut();
    }
    
    public static void updateBut() {
        System.out.println("Connected: "+aClient.connected());
        if(aClient.connected()) {
            
            butConnect.setText("Disconnect");
        }
        else {
            butConnect.setText("Connect");
        }
    }

    
    /**
     * Sends a message
     */
    private void send() {
        String command = txtCommand.getText();
        if (command.length()>0) {
        aClient.chat(command);
        txtCommand.setText("");}
    }

    /**
     * Prints a message to the view
     * @param s the message to print
     */
    static void MessageOut(String s) {
        Time t = new Time(System.currentTimeMillis());
        txtChat.append("\n("+t.toString()+") "+s);
        txtChat.setCaretPosition(txtChat.getText().length());}
    
    /**
     * Update the clientList
     */
    static void updateList() {
        clientList.setListData(aClient.getClients());
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private static javax.swing.JButton butConnect;
    private static javax.swing.JButton butSend;
    private static javax.swing.JList clientList;
    private javax.swing.JScrollPane dialogPane;
    private javax.swing.JScrollPane listPane;
    private static javax.swing.JTextArea txtChat;
    private static javax.swing.JTextField txtCommand;
    // End of variables declaration//GEN-END:variables
 
}
